//=============================================
// CozDecoWallTVSmallINV
//=============================================
Class CozDecoWallTVSmallINV extends CozDecorationINV;

state Activated
{
	function Activate()
	{
		// can't turn it off
	}

	function BeginState()
	{
		local Vector StartTrace, EndTrace, HitLocation, HitNormal;	
		local Actor HitActor;
		local DeusExPlayer P;
		local CozDecoration CD;
		local Vector placeLocation;
		local Vector placeNormal;

		P = DeusExPlayer(Owner);
		Super.BeginState();

		// trace out ten foot in front of the pawn
		StartTrace = Owner.Location;
		EndTrace = StartTrace + Vector(Pawn(Owner).ViewRotation) * 320;

		StartTrace.Z += Pawn(Owner).BaseEyeHeight;
		EndTrace.Z += Pawn(Owner).BaseEyeHeight;

		HitActor = Trace(HitLocation, HitNormal, EndTrace, StartTrace);

		if (HitActor == Level)
		{
			placeLocation = HitLocation;
			placeNormal = HitNormal;
		}

		CD = spawn(DecoClass, Owner,, placeLocation, Rotator(placeNormal));

		CD.MyOwner = P;
		UseOnce();
	}
Begin:
}

defaultproperties
{
     DecoClass=class'RPGMasterTest.CozDecoWallTVSmall'
     ItemName="Small Wall TV"
     beltDescription="TV"
     Description="A small/medium sized TV, designed to attach to surfaces, though intended for walls."
}